/*===================================================================================

  copyright: (C) Copyright 2004-2006 FileMaker, Inc. All Rights Reserved
  
  synopsis: Event handling utilities for iwp.
  =================================================================================*/
/*
	inline javascript moved from IWPLayoutGeneratorPriv.cpp
*/

function getTargetElement(evt) 
{
    var elem
    if (evt.target != null) {
        elem = (evt.target.nodeType == 3) ? evt.target.parentNode : evt.target
    } else {
        elem = evt.srcElement
    }
    return elem
};

function isReturnSpaceOrEnter(keyCode) 
{
	if ((keyCode != null) && ((keyCode == 13) || (keyCode == 32) || (keyCode == 3)))
		return true;
	else 
		return false;
};

function handleEvent(evt) 
{
    if (evt == null)
		evt = ((window.event) ? window.event : "");
    
    if (evt != null) 
	{
        var elem = getTargetElement(evt);
        if (elem) 
		{

			//	if is return space key, or enter invoke the onclick handler
			//	otherwise, return true so navigation will continue
			if (isReturnSpaceOrEnter(evt.keyCode)) 
			{
				elem.onclick();
				return false;
			}
			else
				return true;
        }
    }
};

function CancelEventPropagation()
{
	if (window && window.event) 
	{
		window.event.cancelBubble = true; 
		if (window.event.stopPropagation) 
			window.event.stopPropagation(); 
	}
}

function CancelClick(e)
{
	if (!e) 
		e = window.event;
	if (e)
	{
		e.cancelBubble = true;
		if (e.stopPropagation)
			e.stopPropagation();
		if (e.returnValue)
			e.returnValue = false;
	}
	return false;
}

function isIE()
{
	return window.navigator.userAgent.indexOf("MSIE") >= 1;
}

function formatSelection(obj)
{
	var group = document.getElementsByName(obj.name);
	var isChecked = false;
	var hiddenIndex = -1;
	
	for (var i=0; i<group.length; i++)
	{
		var item = group[i];
		if (item.style.visibility == "hidden")
		{
			hiddenIndex = i;
		} else if (isChecked = group[i].checked)
		{
			break;
		}
	}
	
	if (hiddenIndex != -1)
	{
		var hiddenItem = group[hiddenIndex]; 
	
		if (isChecked)
			hiddenItem.checked = false;
		else 
			hiddenItem.checked = true;
	}
}

function selectControlValue(controlID)
{
	var control = document.getElementById(controlID);
	if (control != null)
	{
		if (control.type == "checkbox")
		{
			control.checked = !control.checked;
		}
		else if (control.type == "radio")
		{
			control.checked = true;
		}
		else 
		{
			return;
		}
		formatSelection(control);
	}
} 

